*************************************************************************
*				ADRENALIN 40				*
*				------------				*
*									*
* Written by:	SPACEMAN SPIFF						*
*									*
* Date:		4/9/93							*
*									*
* Music by: 	Jochen Hipple, hacked by Grazey of PHF			*
*									*
*									*
*									*
*************************************************************************
yes=1
YES=yes
no=0
NO=no

FINAL		equ	no		;YES for disc version
AUTORUN4	equ	no		;NO to run program from here
ASCII_COLOUR	equ	$ffff8242
DISPLAY_TIME	equ	200		;time text is held on screen
					;Increase this to allow user
					;to read text

		ifeq	AUTORUN4
begin		pea	start
		rts
		ds.l	100
ustack		ds.l	1

exec		pea	blank
		pea	blank
		pea	$200.w
		clr.w	-(sp)
		move.w	#$4b,-(sp)
		trap	#1
		lea	16(sp),sp
		pea	reset_me(pc)
		move.w	#$26,-(sp)
		trap	#14
reset_me	move.l	4.w,-(sp)
		rts

blank		dc.l	0

start		move.l	4(a7),a0
		move.l	#ustack,a7
		move.l	#start-begin+$100,-(a7)	;keep only EXEC routine
		move.l	a0,-(a7)
		clr.w	-(a7)
		move.w	#$4a,-(a7)
		trap	#1
		lea	12(a7),a7
		endc

		jsr	set_up

main_loop	jsr	v_sync
		jsr	set_screen	;screen flip
;		move.w	#$123,$ffff8240.w
		bsr	print_text
;		move.w	pic+2,$ffff8240.w

		move.w	key,d0

		cmp.w	#1,d0
		beq.s	exit

		cmp.b	#11,d0		;0 keyboard
		beq	zero

		cmp.b	#$70,d0		;0 keypad
		beq	zero

		cmp.b	#$53,d0		;DEL=RESET!
		beq	reset

		lea	demo_keys,a0
.next		move.w	(a0)+,d1
		bmi	main_loop
		cmp.b	d1,d0
		beq.s	.run
		bra.s	.next
.run		lsr.w	#8,d1
		and.w	#$f,d1
		lsl.w	#2,d1
		lea	filename_table,a0
		move.l	(a0,d1.w),a0
		lea	$200.w,a1
		REPT	4
		move.l	(a0)+,(a1)+
		ENDR

		tst.w	hertz_toggle
		beq.s	hz50
		and.b	#%11111101,$ffff820a.w	;60Hz
hz50


exit		jsr	shut_down

		ifne	FINAL
		ifeq	AUTORUN4
		bra	exec
		endc
		endc

		clr.w	-(sp)
		trap	#1

zero		;flip hertz indicator...
		tst.w	hertz_delay
		bne	main_loop
		eor.w	#$002,hertz_toggle
		move.w	#8,hertz_delay	;delay used to stop key being pressed too fast
		bra	main_loop

reset		move.l	4.w,-(sp)
		rts





****** REMEMBER DON'T USE  D7,A5,A6 *****************************
print_text	tst.w	disc_clear_enable
		bne	.do_clear
		tst.w	disc_enable
		beq.s	.do_stuff
		rts
.do_stuff	move.l	text_pos,a1
		move.l	scr_now,a0
		move.l	last_base,a3
.restart	moveq	#0,d1
		move.b	(a1)+,d1
		move.l	a1,text_pos
		cmp.b	#-1,d1
		bne.s	.no_reset
		move.l	#middle_text,a1
		bra.s	.restart
.no_reset	cmp.b	#"^",d1		;termintor
		bne.s	.do_text
		cmp.b	#13,(a1)
		bne.s	.notcr_here	;if CR is here then take for granted CR,LF
		add.l	#2,text_pos
.notcr_here	move.w	#-1,disc_clear_enable
		move.w	#-1,disc_enable
		move.w	#12*16,lines_to_do
		move.w	#DISPLAY_TIME,do_clear_delay
		clr.b	xpos
		clr.b	ypos
		rts
.do_text	cmp.b	#13,d1
		bne.s	.notcr
		clr.b	xpos
		bra	.restart
.notcr		cmp.b	#10,d1
		bne.s	.notlf
		addq.b	#1,ypos
		bra	.restart
.notlf		cmp.b	#9,d1		;HORIZONTAL TAB
		bne.s	.notab		;routine added 11/2/92 for print speed
;calc TAB by getting MOD 8.
		moveq	#0,d5
		move.b	xpos,d5
		and.w	#%111,d5	;mod 8
		move.w	#8,d4
		sub.w	d5,d4		;sub MOD 8
		add.b	d4,xpos		;add to XPOS so now we are in correct word
		bra	.restart
.notab		sub.b	#32,d1
		mulu	#32,d1
		lea	font,a2
		add.w	d1,a2
		moveq	#0,d0
		move.b	ypos,d0
		mulu	#160*16,d0	;drop down 16 pixels...
		add.l	d0,a0
		add.l	d0,a3
		move.b	xpos,d0
		and.l	#$ff,d0
		lsl.l	#3,d0	;*8	;bytes across screen
		add.l	d0,a0
		add.l	d0,a3
		addq.b	#1,xpos
LINE_OFFSET	set	0
		rept	16
		move.w	(a2),LINE_OFFSET(a0)
		move.w	(a2)+,LINE_OFFSET(a3)
LINE_OFFSET	set	LINE_OFFSET+160
		endr
		rts
.do_clear	tst.w	do_clear_delay
		beq.s	.yeah
		sub.w	#1,do_clear_delay
		rts
.yeah		tst.w	lines_to_do
		beq	.stop
		sub.w	#1,lines_to_do
		move.l	scr_now,a0
		move.l	last_base,a3
		add.l	clear_line_offset,a0
		add.l	clear_line_offset,a3
		moveq	#0,d0
OFF	set	0
		rept	40
		move.w	d0,OFF(a0)
		move.w	d0,OFF(a3)
OFF	set	OFF+8
		endr
		add.l	#160,clear_line_offset
		rts
.stop		clr.w	disc_clear_enable
		move.w	#1,disc_enable
		clr.l	clear_line_offset
		rts

sort_text	lea	middle_text,a0
		lea	disc_start_table,a1
		move.l	a0,(a1)+	;poke start of disc into lookup table
.loop		cmp.b	#$ff,(a0)	;is end of list???
		beq.s	.quit
		move.b	(a0)+,d0
		cmp.b	#'^',d0
		bne.s	.loop
		move.b	(a0)+,d0	;cr
		move.b	(a0)+,d0	;lf
		move.l	a0,(a1)+
		bra.s	.loop
.quit		rts









new_kbd	movem.l	d0,-(sp)
	move.b	$fffffc02.w,d0
	cmp.b	#$1d,d0
	bne.s	.k1
	bset	#2,key
.k1	cmp.b	#$9d,d0
	bne.s	.k2
	bclr	#2,key
.k2	cmp.b	#$38,d0
	bne.s	.k3
	bset	#3,key
.k3	cmp.b	#$b8,d0
	bne.s	.k4
	bclr	#3,key
.k4	move.b	d0,key+1
	bclr	#6,$fffffa11.w
	movem.l	(sp)+,d0
	rte

new_vbl		move.w	#$2700,sr
		move.w	hertz_toggle,$ffff8240.w
		clr.w	vsync_flag
		clr.b	$fffffa1b.w
		move.w	colours,ASCII_COLOUR.w
		move.l	#colours+2,colour_pos
		move.b	#16,$fffffa21.w
		move.b	#8,$fffffa1b.w

		tst.w	$94.w
		bne.s	ggg
		pea	(a0)
		move.l	$90.w,a0
		jsr	(a0)
		move.l	(a7)+,a0
ggg		clr.w	$94.w

		tst.w	disc_enable
		bne.s	.dec
.no_hz_dec	tst.w	hertz_delay
		beq.s	.nhtd
		sub.w	#1,hertz_delay
.nhtd		rte
.dec		sub.w	#1,disc_enable
		tst.w	hertz_delay
		beq.s	.nhtd
		sub.w	#1,hertz_delay
		rte

new_timerb	clr.b	$fffffa1b.w
		move.l	a0,-(sp)
		move.l	colour_pos,a0
		move.w	(a0),ASCII_COLOUR.w
		move.w	(a0)+,ASCII_COLOUR+16.w
		move.l	a0,colour_pos
		move.l	(sp)+,a0
		move.b	#8,$fffffa1b.w
		rte

new60		rts
new90		rts


******* TUNE USES D7,A5,A6 *************
PHF	bra	l0004 
	bra	l0008
	bra	l0000 
	bra	l0002 
	bra	l0001 
	dc.b	'  **** MUSIC BY JOCHEN HIPPEL. **** '
l0000	move.w	d0,l0050
	jmp	grz1
l0001	move.l	a0,$80.w
	rts
 
l0002	lea	freq,a0 
	andi.w	#$f,d0
	add.w	d0,d0 
	add.w	d0,d0 
	move.w	d0,d1 
	add.w	d0,d0 
	add.w	d1,d0 
	adda.w	d0,a0 
	move.l	(a0)+,l0051
	move.l	(a0)+,d0
	move.w	l0003(pc),d1
	mulu	d1,d0 
	divu	#$64,d0 
	subq.w	#1,d0 
	move.w	d0,l0053
	move.l	(a0)+,d0
	move.b	d0,$fffffa23.w
	rts
 
l0003	dc.b	$00,$00 

l0004	move.w	d0,l0050
	addi.w	#$64,d2 
	move.w	d2,l0003
	move.w	d1,d0 
	bsr	l0002 
	move.w	l0053,l0052
	tst.b	grz2
	bne.b	l0006 
	st	grz2
	jsr	grz3
	lea	l003a,a0 
	move.w	#$3ff,d0
l0005	move.b	5(a0),6(a0) 
	addq.l	#8,a0 
	dbf	d0,l0005
l0006	jsr	grz1
	movea.w	#$8800,a5 
	moveq	#0,d0 
	movep.w	d0,0(a5)
	move.w	#$100,d0
	movep.w	d0,0(a5)
	move.w	#$200,d0
	movep.w	d0,0(a5)
	move.w	#$300,d0
	movep.w	d0,0(a5)
	move.w	#$400,d0
	movep.w	d0,0(a5)
	move.w	#$500,d0
	movep.w	d0,0(a5)
	move.w	#$7f8,d0
	movep.w	d0,0(a5)
	clr.w	grz4
	lea	l000e(pc),a0
	tst.b	(a0)
	bne.b	l0007 
	st	(a0)+ 
	move.b	$fffffa07.w,(a0)+ 
	move.b	$fffffa09.w,(a0)+ 
	move.b	$fffffa13.w,(a0)+ 
	move.b	$fffffa15.w,(a0)+ 
	move.b	$fffffa17.w,(a0)+ 
	move.b	$fffffa1d.w,(a0)+ 
	move.l	$114.w,l000d		
	move.l	$70.w,$80.w 
l0007	move.l	#grz5,$70.w 
	sf	$fffffa1d.w 
	bclr	#3,$fffffa17.w
	bset	#5,$fffffa15.w
	bset	#5,$fffffa09.w
	move.l	#$d0,d0 
	move.l	d0,l0023
	move.l	d0,l0029
	move.l	d0,l002f
	move.l	d0,l0035
	moveq	#0,d0 
	move.l	d0,l0010+2
	move.l	d0,l0012+2
	move.l	d0,l0013+2
	move.l	d0,l0014+2
	sf	l0035+4
	sf	l0035+5
	sf	l0035+6
	sf	l0035+7
	clr.l	l011e+$170
	clr.l	l011e+$174
	clr.l	l011e+$178
	clr.l	l011e+$17c
	move.l	#$fff0,d0 
	move.l	d0,d1 
	move.l	d0,d2 
	move.l	d0,d3 
	lea	grz2+$204,a0 
	movea.l	a0,a1 
	movea.l	a0,a2 
	movea.l	a0,a3 
	move.l	a0,PHF+$63d4 
	move.l	a0,PHF+$63e6 
	move.l	a0,PHF+$63f8 
	move.l	a0,PHF+$640a 
	movem.l	a0-a3/d0-d3,PHF+$89dc
	move.l	#PHF+$89fc,PHF+$6416
	move.l	#PHF+$8cac,PHF+$641a
	st	PHF+$89fc
	st	PHF+$8cac
	movea.l	l0037(pc),a6
	move.l	#PHF+$641e,$114.w
	move.b	#$10,$fffffa1d.w
	rts
 
l0008	move	sr,-(a7)
	move	#$2700,sr 
	lea	l000e(pc),a0
	tst.b	(a0)
	beq.b	l0009 
	sf	(a0)+ 
	move.l	l000d(pc),$114.w
	move.l	$80.w,$70.w 
	move.b	(a0)+,$fffffa07.w 
	move.b	(a0)+,$fffffa09.w 
	move.b	(a0)+,$fffffa13.w 
	move.b	(a0)+,$fffffa15.w 
	move.b	(a0)+,$fffffa17.w 
	move.b	(a0)+,$fffffa1d.w 
	move.b	#$c0,$fffffa23.w
l0009	move	(a7)+,sr
	rts
 
grz5	move	#$2700,sr 
	move.w	d0,-(a7)
	move.b	$fffffa1d.w,d0
	andi.b	#$f0,d0 
	cmp.b	#$10,d0 
	bne.b	l000b 
	move.w	(a7)+,d0
	tst.w	grz4
	bne.b	l000a 
	bsr.b	l000c 
l000a	clr.w	grz4
	rte
 
l000b	move.w	(a7)+,d0
	bsr.b	l000c 
	clr.w	grz4
	rte
 
l000c	addq.w	#1,grz4
	trap	#0
	rts
 
grz4	dc.b	$00,$00 
l000d	dcb.w	2,0 
l000e	dcb.w	8,0 
l000f	dcb.w	2,0 
l0010	move.l	#1,d6 
	move.l	a7,l000f
	moveq	#0,d4 
l0011	swap	d5
	move.b	0(a0,d0.w),d5 
	lea	l001d(pc),a7
	move.b	0(a7,d5.w),d5 
	move.b	0(a1,d1.w),d4 
	lea	l001d(pc),a7
	move.b	0(a7,d4.w),d4 
	add.w	d4,d5 
	move.b	0(a2,d2.w),d4 
	lea	l001d(pc),a7
	move.b	0(a7,d4.w),d4 
	add.w	d4,d5 
	move.b	0(a3,d3.w),d4 
	lea	l001d(pc),a7
	move.b	0(a7,d4.w),d4 
	add.w	d4,d5 
	lsl.w	#3,d5 
	move.w	d5,(a4)+
	sub.w	d5,d5 
	add.l	d6,d0 
	addx.w	d5,d0 
	bpl.b	l0015 
l0012	addi.l	#0,d1 
	addx.w	d5,d1 
	bpl.b	l0017 
l0013	addi.l	#0,d2 
	addx.w	d5,d2 
	bpl.b	l0019 
l0014	addi.l	#0,d3 
	addx.w	d5,d3 
	bpl.b	l001b 
	swap	d5
	dbf	d5,l0011
	movea.l	l000f(pc),a7
	rts
 
l0015	movea.l	l0022(pc),a0
	sub.l	l0023(pc),d0
	tst.b	PHF+$a46d
	beq.b	l0016 
	sf	PHF+$a46d
	st	l011e
l0016	bra.b	l0012 
l0017	movea.l	l0028(pc),a1
	sub.l	l0029(pc),d1
	tst.b	PHF+$a471
	beq.b	l0018 
	sf	PHF+$a471
	st	PHF+$a300
l0018	bra.b	l0013 
l0019	movea.l	l002e(pc),a2
	sub.l	l002f(pc),d2
	tst.b	PHF+$a475
	beq.b	l001a 
	sf	PHF+$a475
	st	PHF+$a304
l001a	bra.b	l0014 
l001b	movea.l	l0034(pc),a3
	sub.l	l0035(pc),d3
	tst.b	PHF+$a479
	beq.b	l001c 
	sf	PHF+$a479
	st	PHF+$a308
l001c	swap	d5
	dbf	d5,l0011
	movea.l	l000f(pc),a7
	rts
 
	dcb.w	64,0
l001d	dcb.w	12224,0 
l001e	dcb.w	2,0 
l001f	dc.b	$00,$00 
l0020	dc.b	$00,$00 
l0021	dc.b	$00,$00 
l0022	dcb.w	2,0 
l0023	dcb.w	2,0 
l0024	dcb.w	2,0 
l0025	dc.b	$00,$00 
l0026	dc.b	$00,$00 
l0027	dc.b	$00,$00 
l0028	dcb.w	2,0 
l0029	dcb.w	2,0 
l002a	dcb.w	2,0 
l002b	dc.b	$00,$00 
l002c	dc.b	$00,$00 
l002d	dc.b	$00,$00 
l002e	dcb.w	2,0 
l002f	dcb.w	2,0 
l0030	dcb.w	2,0 
l0031	dc.b	$00,$00 
l0032	dc.b	$00,$00 
l0033	dc.b	$00,$00 
l0034	dcb.w	2,0 
l0035	dcb.w	4,0 
l0036	dcb.w	2,0 
l0037	dcb.w	2,0 
	move.w	(a6)+,d7
	bmi.b	l0038 
	move.l	l003b(pc,d7.w),(a5) 
	move.l	l003a(pc,d7.w),d7 
	movep.l	d7,0(a5)
	rte
 
l0038	movea.l	PHF+$6416,a6 
	move.w	(a6)+,d7
	move.l	l003b(pc,d7.w),(a5) 
	move.l	l003a(pc,d7.w),d7 
	movep.l	d7,0(a5)
	move	#$2300,sr 
	cmpi.b	#$24,(a7) 
	bne.b	l0039 
	bsr	l000c 
l0039	movem.l	a0-a4/d0-d6,-(a7) 
	bsr	l0055 
	bsr	l003c 
	bsr	l0045 
	movea.l	l0037(pc),a4
	move.l	l0036(pc),PHF+$641a
	move.l	a4,PHF+$6416 
	movem.l	PHF+$89dc,a0-a3/d0-d3
	moveq	#0,d5 
	move.w	l0052(pc),d5
	bsr	l0010 
	st	(a4)+ 
	move.w	l0053(pc),PHF+$8f60
	movem.l	a0-a3/d0-d3,PHF+$89dc
	movem.l	(a7)+,a0-a4/d0-d6 
	rte
 
l003a	dc.b	$08,$00,$09,$00 
l003b	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$02,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$03,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$04,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$05,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$05,$09,$01 
	dc.b	$0a,$00,$00,$00,$08,$06,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$06,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$06,$09,$02 
	dc.b	$0a,$00,$00,$00,$08,$07,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$07,$09,$02 
	dc.b	$0a,$00,$00,$00,$08,$07,$09,$03 
	dc.b	$0a,$00,$00,$00,$08,$08,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$08,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$08,$09,$02 
	dc.b	$0a,$00,$00,$00,$08,$08,$09,$03 
	dc.b	$0a,$00,$00,$00,$08,$09,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$09,$09,$01 
	dc.b	$0a,$00,$00,$00,$08,$09,$09,$02 
	dc.b	$0a,$00,$00,$00,$08,$09,$09,$03 
	dc.b	$0a,$00,$00,$00,$08,$09,$09,$04 
	dc.b	$0a,$00,$00,$00,$08,$09,$09,$05 
	dc.b	$0a,$00,$00,$00,$08,$09,$09,$05 
	dc.b	$0a,$01,$00,$00,$08,$0a,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$0a,$09,$02 
	dc.b	$0a,$00,$00,$00,$08,$0a,$09,$03 
	dc.b	$0a,$00,$00,$00,$08,$0a,$09,$04 
	dc.b	$0a,$00,$00,$00,$08,$0a,$09,$05 
	dc.b	$0a,$00,$00,$00,$08,$0a,$09,$05 
	dc.b	$0a,$00,$00,$00,$08,$0a,$09,$05 
	dc.b	$0a,$02,$00,$00,$08,$0a,$09,$06 
	dc.b	$0a,$00,$00,$00,$08,$0a,$09,$06 
	dc.b	$0a,$02,$00,$00,$08,$0a,$09,$07 
	dc.b	$0a,$00,$00,$00,$08,$0a,$09,$07 
	dc.b	$0a,$01,$00,$00,$08,$0b,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$0b,$09,$01 
	dc.b	$0a,$00,$00,$00,$08,$0b,$09,$03 
	dc.b	$0a,$00,$00,$00,$08,$0b,$09,$04 
	dc.b	$0a,$00,$00,$00,$08,$0b,$09,$04 
	dc.b	$0a,$00,$00,$00,$08,$0b,$09,$05 
	dc.b	$0a,$00,$00,$00,$08,$0b,$09,$05 
	dc.b	$0a,$02,$00,$00,$08,$0b,$09,$06 
	dc.b	$0a,$00,$00,$00,$08,$0b,$09,$06 
	dc.b	$0a,$01,$00,$00,$08,$0b,$09,$07 
	dc.b	$0a,$00,$00,$00,$08,$0b,$09,$07 
	dc.b	$0a,$01,$00,$00,$08,$0b,$09,$07 
	dc.b	$0a,$02,$00,$00,$08,$0b,$09,$07 
	dc.b	$0a,$03,$00,$00,$08,$0b,$09,$08 
	dc.b	$0a,$00,$00,$00,$08,$0b,$09,$08 
	dc.b	$0a,$01,$00,$00,$08,$0b,$09,$08 
	dc.b	$0a,$03,$00,$00,$08,$0b,$09,$08 
	dc.b	$0a,$04,$00,$00,$08,$0b,$09,$09 
	dc.b	$0a,$00,$00,$00,$08,$0c,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$0c,$09,$02 
	dc.b	$0a,$00,$00,$00,$08,$0c,$09,$03 
	dc.b	$0a,$00,$00,$00,$08,$0c,$09,$04 
	dc.b	$0a,$00,$00,$00,$08,$0c,$09,$05 
	dc.b	$0a,$00,$00,$00,$08,$0c,$09,$05 
	dc.b	$0a,$01,$00,$00,$08,$0c,$09,$05 
	dc.b	$0a,$02,$00,$00,$08,$0c,$09,$06 
	dc.b	$0a,$00,$00,$00,$08,$0c,$09,$06 
	dc.b	$0a,$02,$00,$00,$08,$0c,$09,$07 
	dc.b	$0a,$00,$00,$00,$08,$0c,$09,$07 
	dc.b	$0a,$02,$00,$00,$08,$0c,$09,$07 
	dc.b	$0a,$03,$00,$00,$08,$0c,$09,$08 
	dc.b	$0a,$00,$00,$00,$08,$0c,$09,$08 
	dc.b	$0a,$00,$00,$00,$08,$0c,$09,$08 
	dc.b	$0a,$02,$00,$00,$08,$0c,$09,$08 
	dc.b	$0a,$03,$00,$00,$08,$0c,$09,$09 
	dc.b	$0a,$00,$00,$00,$08,$0c,$09,$09 
	dc.b	$0a,$00,$00,$00,$08,$0c,$09,$09 
	dc.b	$0a,$02,$00,$00,$08,$0c,$09,$09 
	dc.b	$0a,$03,$00,$00,$08,$0c,$09,$09 
	dc.b	$0a,$04,$00,$00,$08,$0c,$09,$09 
	dc.b	$0a,$05,$00,$00,$08,$0c,$09,$09 
	dc.b	$0a,$05,$00,$00,$08,$0c,$09,$0a 
	dc.b	$0a,$00,$00,$00,$08,$0d,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$0d,$09,$02 
	dc.b	$0a,$00,$00,$00,$08,$0d,$09,$03 
	dc.b	$0a,$00,$00,$00,$08,$0d,$09,$04 
	dc.b	$0a,$00,$00,$00,$08,$0d,$09,$05 
	dc.b	$0a,$00,$00,$00,$08,$0d,$09,$05 
	dc.b	$0a,$00,$00,$00,$08,$0d,$09,$05 
	dc.b	$0a,$02,$00,$00,$08,$0d,$09,$06 
	dc.b	$0a,$00,$00,$00,$08,$0d,$09,$06 
	dc.b	$0a,$02,$00,$00,$08,$0d,$09,$07 
	dc.b	$0a,$00,$00,$00,$08,$0d,$09,$07 
	dc.b	$0a,$01,$00,$00,$08,$0d,$09,$07 
	dc.b	$0a,$03,$00,$00,$08,$0d,$09,$07 
	dc.b	$0a,$04,$00,$00,$08,$0d,$09,$08 
	dc.b	$0a,$00,$00,$00,$08,$0d,$09,$08 
	dc.b	$0a,$02,$00,$00,$08,$0d,$09,$08 
	dc.b	$0a,$03,$00,$00,$08,$0d,$09,$09 
	dc.b	$0a,$00,$00,$00,$08,$0d,$09,$09 
	dc.b	$0a,$00,$00,$00,$08,$0d,$09,$09 
	dc.b	$0a,$02,$00,$00,$08,$0d,$09,$09 
	dc.b	$0a,$03,$00,$00,$08,$0d,$09,$09 
	dc.b	$0a,$04,$00,$00,$08,$0d,$09,$09 
	dc.b	$0a,$05,$00,$00,$08,$0d,$09,$09 
	dc.b	$0a,$05,$00,$00,$08,$0d,$09,$0a 
	dc.b	$0a,$00,$00,$00,$08,$0d,$09,$0a 
	dc.b	$0a,$01,$00,$00,$08,$0d,$09,$0a 
	dc.b	$0a,$03,$00,$00,$08,$0d,$09,$0a 
	dc.b	$0a,$04,$00,$00,$08,$0d,$09,$0a 
	dc.b	$0a,$04,$00,$00,$08,$0d,$09,$0a 
	dc.b	$0a,$05,$00,$00,$08,$0d,$09,$0a 
	dc.b	$0a,$05,$00,$00,$08,$0d,$09,$0a 
	dc.b	$0a,$06,$00,$00,$08,$0d,$09,$0a 
	dc.b	$0a,$06,$00,$00,$08,$0d,$09,$0a 
	dc.b	$0a,$07,$00,$00,$08,$0d,$09,$0a 
	dc.b	$0a,$07,$00,$00,$08,$0d,$09,$0b 
	dc.b	$0a,$00,$00,$00,$08,$0d,$09,$0b 
	dc.b	$0a,$01,$00,$00,$08,$0d,$09,$0b 
	dc.b	$0a,$02,$00,$00,$08,$0d,$09,$0b 
	dc.b	$0a,$03,$00,$00,$08,$0d,$09,$0b 
	dc.b	$0a,$04,$00,$00,$08,$0d,$09,$0b 
	dc.b	$0a,$05,$00,$00,$08,$0d,$09,$0b 
	dc.b	$0a,$05,$00,$00,$08,$0d,$09,$0b 
	dc.b	$0a,$06,$00,$00,$08,$0e,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$0e,$09,$01 
	dc.b	$0a,$00,$00,$00,$08,$0e,$09,$03 
	dc.b	$0a,$00,$00,$00,$08,$0e,$09,$04 
	dc.b	$0a,$00,$00,$00,$08,$0e,$09,$04 
	dc.b	$0a,$01,$00,$00,$08,$0e,$09,$05 
	dc.b	$0a,$00,$00,$00,$08,$0e,$09,$05 
	dc.b	$0a,$02,$00,$00,$08,$0e,$09,$06 
	dc.b	$0a,$00,$00,$00,$08,$0e,$09,$06 
	dc.b	$0a,$01,$00,$00,$08,$0e,$09,$07 
	dc.b	$0a,$00,$00,$00,$08,$0e,$09,$07 
	dc.b	$0a,$01,$00,$00,$08,$0e,$09,$07 
	dc.b	$0a,$03,$00,$00,$08,$0e,$09,$07 
	dc.b	$0a,$04,$00,$00,$08,$0e,$09,$08 
	dc.b	$0a,$00,$00,$00,$08,$0e,$09,$08 
	dc.b	$0a,$01,$00,$00,$08,$0e,$09,$08 
	dc.b	$0a,$03,$00,$00,$08,$0e,$09,$08 
	dc.b	$0a,$04,$00,$00,$08,$0e,$09,$09 
	dc.b	$0a,$00,$00,$00,$08,$0e,$09,$09 
	dc.b	$0a,$02,$00,$00,$08,$0e,$09,$09 
	dc.b	$0a,$03,$00,$00,$08,$0e,$09,$09 
	dc.b	$0a,$04,$00,$00,$08,$0e,$09,$09 
	dc.b	$0a,$05,$00,$00,$08,$0e,$09,$09 
	dc.b	$0a,$05,$00,$00,$08,$0e,$09,$0a 
	dc.b	$0a,$00,$00,$00,$08,$0e,$09,$0a 
	dc.b	$0a,$01,$00,$00,$08,$0e,$09,$0a 
	dc.b	$0a,$03,$00,$00,$08,$0e,$09,$0a 
	dc.b	$0a,$04,$00,$00,$08,$0e,$09,$0a 
	dc.b	$0a,$04,$00,$00,$08,$0e,$09,$0a 
	dc.b	$0a,$05,$00,$00,$08,$0e,$09,$0a 
	dc.b	$0a,$05,$00,$00,$08,$0e,$09,$0a 
	dc.b	$0a,$06,$00,$00,$08,$0e,$09,$0a 
	dc.b	$0a,$06,$00,$00,$08,$0e,$09,$0a 
	dc.b	$0a,$07,$00,$00,$08,$0e,$09,$0a 
	dc.b	$0a,$07,$00,$00,$08,$0e,$09,$0a 
	dc.b	$0a,$07,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$00,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$02,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$03,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$04,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$05,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$05,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$05,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$06,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$06,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$07,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$07,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$07,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$08,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$08,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$08,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$08,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$09,$00,$00,$08,$0e,$09,$0c 
	dc.b	$0a,$00,$00,$00,$08,$0e,$09,$0c 
	dc.b	$0a,$01,$00,$00,$08,$0e,$09,$0c 
	dc.b	$0a,$03,$00,$00,$08,$0e,$09,$0c 
	dc.b	$0a,$04,$00,$00,$08,$0e,$09,$0c 
	dc.b	$0a,$04,$00,$00,$08,$0e,$09,$0c 
	dc.b	$0a,$05,$00,$00,$08,$0f,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$0f,$09,$01 
	dc.b	$0a,$00,$00,$00,$08,$0f,$09,$03 
	dc.b	$0a,$00,$00,$00,$08,$0f,$09,$04 
	dc.b	$0a,$00,$00,$00,$08,$0f,$09,$04 
	dc.b	$0a,$01,$00,$00,$08,$0f,$09,$05 
	dc.b	$0a,$00,$00,$00,$08,$0f,$09,$05 
	dc.b	$0a,$02,$00,$00,$08,$0f,$09,$06 
	dc.b	$0a,$00,$00,$00,$08,$0f,$09,$06 
	dc.b	$0a,$01,$00,$00,$08,$0f,$09,$07 
	dc.b	$0a,$00,$00,$00,$08,$0f,$09,$07 
	dc.b	$0a,$01,$00,$00,$08,$0f,$09,$07 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$07 
	dc.b	$0a,$04,$00,$00,$08,$0f,$09,$08 
	dc.b	$0a,$00,$00,$00,$08,$0f,$09,$08 
	dc.b	$0a,$02,$00,$00,$08,$0f,$09,$08 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$08 
	dc.b	$0a,$04,$00,$00,$08,$0f,$09,$09 
	dc.b	$0a,$00,$00,$00,$08,$0f,$09,$09 
	dc.b	$0a,$02,$00,$00,$08,$0f,$09,$09 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$09 
	dc.b	$0a,$04,$00,$00,$08,$0f,$09,$09 
	dc.b	$0a,$05,$00,$00,$08,$0f,$09,$09 
	dc.b	$0a,$05,$00,$00,$08,$0f,$09,$0a 
	dc.b	$0a,$00,$00,$00,$08,$0f,$09,$0a 
	dc.b	$0a,$01,$00,$00,$08,$0f,$09,$0a 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0a 
	dc.b	$0a,$04,$00,$00,$08,$0f,$09,$0a 
	dc.b	$0a,$04,$00,$00,$08,$0f,$09,$0a 
	dc.b	$0a,$05,$00,$00,$08,$0f,$09,$0a 
	dc.b	$0a,$05,$00,$00,$08,$0f,$09,$0a 
	dc.b	$0a,$06,$00,$00,$08,$0f,$09,$0a 
	dc.b	$0a,$06,$00,$00,$08,$0f,$09,$0a 
	dc.b	$0a,$07,$00,$00,$08,$0f,$09,$0a 
	dc.b	$0a,$07,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$00,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$00,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$02,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$04,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$05,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$05,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$06,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$06,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$06,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$07,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$07,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$07,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$08,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$08,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$08,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$08,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$09,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$00,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$01,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$04,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$04,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$05,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$05,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$06,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$06,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$07,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$07,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$07,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$07,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$08,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$08,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$08,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$08,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$09,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$09,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$09,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$09,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$09,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$09,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$0a,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$00,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$01,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00 

l003c	move.w	l0020(pc),d0
	beq.b	l003e 
	move.w	l0021(pc),d2
	andi.w	#$ff,d2 
	cmp.w	#$40,d2 
	blt.b	l003d 
	move.w	#$3f,d2 
l003d	mulu	#$180,d2
	move.l	l0051(pc),d1
	divu	d0,d1 
	andi.l	#$ffff,d1 
	lsl.l	#5,d1 
	swap	d1
	lea	PHF+$044a,a0 
	suba.l	#PHF+$02e2,a0
	add.l	a0,d2 
	move.l	d1,PHF+$02ce 
	move.w	d2,PHF+$02e2 
l003e	move.w	l0026(pc),d0
	beq.b	l0040 
	move.w	l0027(pc),d2
	andi.w	#$ff,d2 
	cmp.w	#$40,d2 
	blt.b	l003f 
	move.w	#$3f,d2 
l003f	mulu	#$180,d2
	move.l	l0051(pc),d1
	divu	d0,d1 
	andi.l	#$ffff,d1 
	lsl.l	#5,d1 
	swap	d1
	lea	PHF+$044a,a0 
	suba.l	#PHF+$02ee,a0
	add.l	a0,d2 
	move.l	d1,PHF+$0320 
	move.w	d2,PHF+$02ee 
l0040	move.w	l002c(pc),d0
	beq.b	l0042 
	move.w	l002d(pc),d2
	andi.w	#$ff,d2 
	cmp.w	#$40,d2 
	blt.b	l0041 
	move.w	#$3f,d2 
l0041	mulu	#$180,d2
	move.l	l0051(pc),d1
	divu	d0,d1 
	andi.l	#$ffff,d1 
	lsl.l	#5,d1 
	swap	d1
	lea	PHF+$044a,a0 
	suba.l	#PHF+$02fc,a0
	add.l	a0,d2 
	move.l	d1,PHF+$032a 
	move.w	d2,PHF+$02fc 
l0042	move.w	l0032(pc),d0
	beq.b	l0044 
	move.w	l0033(pc),d2
	andi.w	#$ff,d2 
	cmp.w	#$40,d2 
	blt.b	l0043 
	move.w	#$3f,d2 
l0043	mulu	#$180,d2
	move.l	l0051(pc),d1
	divu	d0,d1 
	andi.l	#$ffff,d1 
	lsl.l	#5,d1 
	swap	d1
	lea	PHF+$044a,a0 
	suba.l	#PHF+$030a,a0
	add.l	a0,d2 
	move.l	d1,PHF+$0334 
	move.w	d2,PHF+$030a 
l0044	rts
 
l0045	tst.b	PHF+$a46c
	bne.b	l0046 
	clr.l	PHF+$02ce
	st	PHF+$6412
	bra.b	l0047 
l0046	move.l	l001e(pc),d0
	move.w	l001f(pc),d1
	andi.l	#$3fff,d1 
	add.l	d1,d1 
	add.l	d1,d0 
	move.l	d0,PHF+$63d4 
	move.l	d1,PHF+$63d8 
	tst.b	PHF+$6412
	beq.b	l0047 
	sf	PHF+$6412
	movea.l	l001e(pc),a0
	moveq	#0,d0 
	move.w	l001f(pc),d0
	andi.w	#$3fff,d0 
	add.w	d0,d0 
	adda.l	d0,a0 
	move.l	a0,PHF+$89ec 
	neg.l	d0
	move.l	d0,PHF+$89dc 
l0047	tst.b	PHF+$a470
	bne.b	l0048 
	clr.l	PHF+$0320
	st	PHF+$6413
	bra.b	l0049 
l0048	move.l	l0024(pc),d0
	move.w	l0025(pc),d1
	andi.l	#$3fff,d1 
	add.l	d1,d1 
	add.l	d1,d0 
	move.l	d0,PHF+$63e6 
	move.l	d1,PHF+$63ea 
	tst.b	PHF+$6413
	beq.b	l0049 
	sf	PHF+$6413
	movea.l	l0024(pc),a0
	move.l	a0,PHF+$63e6 
	moveq	#0,d0 
	move.w	l0025(pc),d0
	andi.w	#$3fff,d0 
	add.w	d0,d0 
	adda.l	d0,a0 
	move.l	d0,PHF+$63ea 
	move.l	a0,PHF+$89f0 
	neg.l	d0
	move.l	d0,PHF+$89e0 
l0049	tst.b	PHF+$a474
	bne.b	l004a 
	st	PHF+$6414
	clr.l	PHF+$032a
	bra.b	l004b 
l004a	move.l	l002a(pc),d0
	move.w	l002b(pc),d1
	andi.l	#$3fff,d1 
	add.l	d1,d1 
	add.l	d1,d0 
	move.l	d0,PHF+$63f8 
	move.l	d1,PHF+$63fc 
	tst.b	PHF+$6414
	beq.b	l004b 
	sf	PHF+$6414
	movea.l	l002a(pc),a0
	move.l	a0,PHF+$63f8 
	moveq	#0,d0 
	move.w	l002b(pc),d0
	andi.w	#$3fff,d0 
	add.w	d0,d0 
	adda.l	d0,a0 
	move.l	d0,d1 
	move.l	d0,PHF+$63fc 
	move.l	a0,PHF+$89f4 
	neg.l	d0
	move.l	d0,PHF+$89e4 
l004b	tst.b	PHF+$a478
	bne.b	l004c 
	clr.l	PHF+$0334
	st	PHF+$6415
	bra.b	l004d 
l004c	move.l	l0030(pc),d0
	move.w	l0031(pc),d1
	andi.l	#$3fff,d1 
	add.l	d1,d1 
	add.l	d1,d0 
	move.l	d0,PHF+$640a 
	move.l	d1,PHF+$640e 
	tst.b	PHF+$6415
	beq.b	l004d 
	sf	PHF+$6415
	movea.l	l0030(pc),a0
	move.l	a0,PHF+$640a 
	moveq	#0,d0 
	move.w	l0031(pc),d0
	andi.w	#$3fff,d0 
	add.w	d0,d0 
	adda.l	d0,a0 
	move.l	d0,PHF+$640e 
	move.l	a0,PHF+$89f8 
	neg.l	d0
	move.l	d0,PHF+$89e8 
l004d	rts
 
grz3	lea	PHF+$044a,a0 
	moveq	#0,d7 
	moveq	#$3f,d0 
l004e	moveq	#0,d6 
	move.w	#$ff,d1 
l004f	move.w	d6,d2 
	ext.w	d2
	muls	d7,d2 
	divs	#$3f,d2 
	addi.b	#$80,d2 
	move.b	d2,(a0)+
	addq.w	#1,d6 
	dbf	d1,l004f
	lea	128(a0),a0
	addq.w	#1,d7 
	dbf	d0,l004e
	rts
 
grz1	bsr	l0054 
	move.l	#PHF+$a6b2,d0
	move.l	#PHF+$e442,d1
	bsr	l0057 
	move.w	l0050(pc),d0
	bsr	l0056 
	rts
 
grz2	dc.b	$00,$00 
l0050	dcb.w	289,0 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff 
l0051	dc.b	$00,$07,$fd,'t' 
l0052	dc.b	$00,$00 

l0053	dc.b	$00,$00

freq	;incbin	"b:turr2.frq"

	dc.b	$00,$12,$a8,$00,$00,$00 
	dc.b	$00,'x',$00,$00,$00,'f',$00,$0f 
	dc.b	$f8,$00,$00,$00,$00,$8c,$00,$00 
	dc.b	$00,'W',$00,$0d,$f8,$00,$00,$00 
	dc.b	$00,$a0,$00,$00,$00,'M',$00,$0c 
	dc.b	'h',$00,$00,$00,$00,$b4,$00,$00 
	dc.b	$00,'D',$00,$0b,'0',$00,$00,$00 
	dc.b	$00,$c8,$00,$00,$00,'=',$00,$0a 
	dc.b	'(',$00,$00,$00,$00,$dc,$00,$00 
	dc.b	$00,'8',$00,$09,'P',$00,$00,$00 
	dc.b	$00,$f0,$00,$00,$00,'3',$00,$08 
	dc.b	$98,$00,$00,$00,$01,$04,$00,$00 
	dc.b	$00,'/',$00,$08,$00,$00,$00,$00 
	dc.b	$01,$18,$00,$00,$00,',',$00,$07 
	dc.b	'x',$00,$00,$00,$01,',',$00,$00 
	dc.b	$00,')' 

l0054	bra	l0100 
l0055	bra	l0058 
	bra	l0100 
l0056	bra	l0117 
	bra	l00f7 
l0057	bra	l0119 
	bra	l011c 
	bra	l00ff 
	bra	l0116 
	bra	l0109 
	bra	l010d 
	bra	l0100 
	bra	l010e 
	bra	l010f 
	bra	l0110 
	bra	l0118 
	bra	l0100 
	bra	l0100 
	bra	l0100 
	bra	l0100 
	bra	l011b 
l0058	movem.l	a0-a4/d0-d6,-(a7) 
	lea	l011d(pc),a3
	move.l	40(a3),-(a7)
	tst.w	60(a3)
	bmi.b	l0059 
	bsr	l0101 
	bra.b	l005d 
l0059	tst.b	8(a3) 
	beq.b	l005a 
	tst.b	46(a3)
	bne.b	l005b 
l005a	bra.b	l005d 
l005b	tst.b	12(a3)
	bmi.b	l005c 
	bsr.b	l005e 
l005c	bsr	l0098 
l005d	move.l	(a7)+,40(a3)
	movem.l	(a7)+,a0-a4/d0-d6 
	rts
 
l005e	lea	l011f(pc),a2
	movea.l	0(a3),a4
	tst.w	44(a3)
	beq.b	l005f 
	subq.w	#1,44(a3) 
	rts
 
l005f	move.w	6(a2),44(a3)
l0060	movea.l	a2,a0 
	clr.b	9(a3) 
	bsr.b	l0062 
	tst.b	9(a3) 
	bne.b	l0060 
	bsr.b	l0061 
	tst.b	9(a3) 
	bne.b	l0060 
	bsr.b	l0061 
	tst.b	9(a3) 
	bne.b	l0060 
	bsr.b	l0061 
	tst.b	9(a3) 
	bne.b	l0060 
	bsr.b	l0061 
	tst.b	9(a3) 
	bne.b	l0060 
	bsr.b	l0061 
	tst.b	9(a3) 
	bne.b	l0060 
	bsr.b	l0061 
	tst.b	9(a3) 
	bne.b	l0060 
	bsr.b	l0061 
	tst.b	9(a3) 
	bne.b	l0060 
	rts
 
l0061	addq.l	#4,a0 
l0062	cmpi.b	#$90,72(a0) 
	bcs.b	l0063 
	cmpi.b	#$fe,72(a0) 
	bne.b	l0064 
	move.b	#$ff,72(a0) 
	move.b	73(a0),d0 
	bra	l00ff 
l0063	tst.w	106(a0) 
	beq.b	l0065 
	subq.w	#1,106(a0)
l0064	rts
 
l0065	move.w	104(a0),d0
	add.w	d0,d0 
	add.w	d0,d0 
	movea.l	40(a0),a1 
	move.l	0(a1,d0.w),40(a3) 
	cmpi.b	#$f0,40(a3) 
	bcc.b	l0068 
	move.b	40(a3),48(a3) 
	cmpi.b	#$c0,40(a3) 
	bcc.b	l0066 
	cmpi.b	#$7f,40(a3) 
	bcs.b	l0066 
	move.b	43(a3),107(a0)
	andi.w	#$ff00,42(a3) 
l0066	move.b	73(a0),d0 
	add.b	d0,40(a3) 
	cmpi.b	#$c0,48(a3) 
	bcc.b	l0067 
	andi.b	#$3f,40(a3) 
l0067	move.l	40(a3),d0 
	bsr	l00f7 
	cmpi.b	#$c0,48(a3) 
	bcc.b	l006a 
	cmpi.b	#$7f,48(a3) 
	bcs.b	l006a 
	bra	l0075 
l0068	move.b	40(a3),d0 
	andi.w	#$f,d0
	add.w	d0,d0 
	add.w	d0,d0 
	jmp	l0069(pc,d0.w)
l0069	bra	l006b 
	bra	l006f 
	bra	l0073 
	bra	l0074 
	bra	l0077 
	bra	l0078 
	bra	l0078 
	bra	l0078 
	bra	l007a 
	bra	l007b 
	bra	l007c 
	bra	l007f 
	bra	l0078 
	bra	l006a 
	bra	l0076 
	bra	l006a 
l006a	addq.w	#1,104(a0)
	bra	l0065 
l006b	cmpi.b	#$80,72(a0) 
	bcs.b	l006c 
	move.b	#$ff,72(a0) 
l006c	move.w	4(a2),d0
	cmp.w	2(a2),d0
	bne.b	l006d 
	move.w	0(a2),4(a2) 
	bra.b	l006e 
l006d	addq.w	#1,4(a2)
l006e	bsr	l0080 
	move.b	#$ff,9(a3)
	rts
 
l006f	tst.b	74(a0)
	beq.b	l0070 
	cmpi.b	#$ff,74(a0) 
	beq.b	l0071 
	subq.b	#1,74(a0) 
	bra.b	l0072 
l0070	move.b	#$ff,74(a0) 
	bra.b	l006a 
l0071	move.b	41(a3),d0 
	subq.b	#1,d0 
	move.b	d0,74(a0) 
l0072	move.w	42(a3),104(a0)
	bra	l0065 
l0073	move.b	41(a3),d0 
	andi.w	#$7f,d0 
	move.b	d0,72(a0) 
	add.w	d0,d0 
	add.w	d0,d0 
	movea.l	a4,a1 
	adda.l	#$400,a1
	move.l	0(a1,d0.w),d0 
	add.l	a4,d0 
	move.l	d0,40(a0) 
	move.w	42(a3),104(a0)
	bra	l0065 
l0074	move.b	41(a3),107(a0)
l0075	addq.w	#1,104(a0)
	rts
 
l0076	clr.w	64(a3)
l0077	move.b	#$ff,72(a0) 
	rts
 
l0078	move.l	40(a3),d0 
	tst.w	8(a0) 
	bne.b	l0079 
	bsr	l00f7 
l0079	bra	l006a 
l007a	move.l	40(a0),136(a0)
	move.w	104(a0),168(a0) 
	move.b	41(a3),d0 
	andi.w	#$7f,d0 
	move.b	d0,72(a0) 
	add.w	d0,d0 
	add.w	d0,d0 
	movea.l	a4,a1 
	adda.l	#$400,a1
	move.l	0(a1,d0.w),d0 
	add.l	a4,d0 
	move.l	d0,40(a0) 
	move.w	42(a3),104(a0)
	bra	l0065 
l007b	move.l	136(a2),40(a2)
	move.w	168(a2),104(a2) 
	bra	l006a 
l007c	lea	l0121(pc),a1
	tst.w	0(a1) 
	bne	l006a 
	move.w	#1,0(a1)
	move.b	43(a3),81(a3) 
	move.b	41(a3),82(a3) 
	move.b	41(a3),83(a3) 
	beq.b	l007d 
	move.b	#1,28(a3) 
	move.b	80(a3),d0 
	cmp.b	81(a3),d0 
	beq.b	l007e 
	bcs	l006a 
	neg.b	28(a3)
	bra	l006a 
l007d	move.b	81(a3),80(a3) 
l007e	move.b	#0,28(a3) 
	clr.w	0(a1) 
	bra	l006a 
l007f	move.b	42(a3),d1 
	andi.w	#7,d1 
	add.w	d1,d1 
	add.w	d1,d1 
	move.b	41(a3),d0 
	move.b	d0,72(a2,d1.w)
	move.b	43(a3),73(a2,d1.w)
	andi.w	#$7f,d0 
	add.w	d0,d0 
	add.w	d0,d0 
	movea.l	a4,a1 
	adda.l	#$400,a1
	move.l	0(a1,d0.w),d0 
	add.l	a4,d0 
	move.l	d0,40(a2,d1.w)
	clr.l	104(a2,d1.w)
	move.w	#$ffff,74(a2,d1.w)
	bra	l006a 
l0080	movem.l	a0-a1/d0,-(a7)
l0081	moveq	#0,d0 
	move.w	4(a2),d0
	lsl.w	#4,d0 
	add.l	a4,d0 
	addi.l	#$800,d0
	movea.l	d0,a0 
	movea.l	a4,a1 
	adda.l	#$400,a1
	move.w	(a0)+,d0
	cmp.w	#$effe,d0 
	bne.b	l0084 
	move.w	(a0)+,d0
	add.w	d0,d0 
	add.w	d0,d0 
	cmp.w	#$14,d0 
	bcs.b	l0082 
	moveq	#0,d0 
l0082	jmp	l0083(pc,d0.w)
l0083	bra	l008d 
	bra	l008e 
	bra	l0092 
	bra	l0094 
	bra	l0095 
l0084	move.w	d0,72(a2) 
	bmi.b	l0085 
	andi.w	#$7f00,d0 
	lsr.w	#6,d0 
	move.l	0(a1,d0.w),d0 
	add.l	a4,d0 
	move.l	d0,40(a2) 
	clr.l	104(a2) 
	move.w	#$ffff,74(a2) 
l0085	move.w	(a0)+,d0
	move.w	d0,76(a2) 
	bmi.b	l0086 
	andi.w	#$7f00,d0 
	lsr.w	#6,d0 
	move.l	0(a1,d0.w),d0 
	add.l	a4,d0 
	move.l	d0,44(a2) 
	clr.l	108(a2) 
	move.w	#$ffff,78(a2) 
l0086	move.w	(a0)+,d0
	move.w	d0,80(a2) 
	bmi.b	l0087 
	andi.w	#$7f00,d0 
	lsr.w	#6,d0 
	move.l	0(a1,d0.w),d0 
	add.l	a4,d0 
	move.l	d0,48(a2) 
	clr.l	112(a2) 
	move.w	#$ffff,82(a2) 
l0087	move.w	(a0)+,d0
	move.w	d0,84(a2) 
	bmi.b	l0088 
	andi.w	#$7f00,d0 
	lsr.w	#6,d0 
	move.l	0(a1,d0.w),d0 
	add.l	a4,d0 
	move.l	d0,52(a2) 
	clr.l	116(a2) 
	move.w	#$ffff,86(a2) 
l0088	move.w	(a0)+,d0
	move.w	d0,88(a2) 
	bmi.b	l0089 
	andi.w	#$7f00,d0 
	lsr.w	#6,d0 
	move.l	0(a1,d0.w),d0 
	add.l	a4,d0 
	move.l	d0,56(a2) 
	clr.l	120(a2) 
	move.w	#$ffff,90(a2) 
l0089	move.w	(a0)+,d0
	move.w	d0,92(a2) 
	bmi.b	l008a 
	andi.w	#$7f00,d0 
	lsr.w	#6,d0 
	move.l	0(a1,d0.w),d0 
	add.l	a4,d0 
	move.l	d0,60(a2) 
	clr.l	124(a2) 
	move.w	#$ffff,94(a2) 
l008a	move.w	(a0)+,d0
	move.w	d0,96(a2) 
	bmi.b	l008b 
	andi.w	#$7f00,d0 
	lsr.w	#6,d0 
	move.l	0(a1,d0.w),d0 
	add.l	a4,d0 
	move.l	d0,64(a2) 
	clr.l	128(a2) 
	move.w	#$ffff,98(a2) 
l008b	tst.w	64(a3)
	bne.b	l008c 
	move.w	(a0)+,d0
	move.w	d0,100(a2)
	bmi.b	l008c 
	andi.w	#$7f00,d0 
	lsr.w	#6,d0 
	move.l	0(a1,d0.w),d0 
	add.l	a4,d0 
	move.l	d0,68(a2) 
	clr.l	132(a2) 
	move.w	#$ffff,102(a2)
l008c	movem.l	(a7)+,a0-a1/d0
	rts
 
	bsr	l010e 
l008d	clr.b	46(a3)
	movem.l	(a7)+,a0-a1/d0
	rts
 
l008e	tst.w	94(a3)
	beq.b	l008f 
	bmi.b	l0090 
	subq.w	#1,94(a3) 
	bra.b	l0091 
l008f	move.w	#$ffff,94(a3) 
	addq.w	#1,4(a2)
	bra	l0081 
l0090	move.w	2(a0),d0
	subq.w	#1,d0 
	move.w	d0,94(a3) 
l0091	move.w	(a0),4(a2)
	bra	l0081 
l0092	move.w	(a0),6(a2)
	move.w	(a0),44(a3) 
	move.w	2(a0),d0
	bmi	l0093 
	andi.w	#$1ff,d0
	tst.w	d0
	beq	l0093 
	move.l	#$1b51f8,d1 
	divu	d0,d1 
	move.w	d1,52(a3) 
l0093	addq.w	#1,4(a2)
	bra	l0081 
l0094	move.b	(a0),62(a3) 
	addq.w	#1,4(a2)
	bra	l0081 
l0095	addq.w	#1,4(a2)
	lea	l0121(pc),a1
	tst.w	0(a1) 
	bne	l0081 
	move.w	#1,0(a1)
	move.b	3(a0),81(a3)
	move.b	1(a0),82(a3)
	move.b	1(a0),83(a3)
	beq.b	l0096 
	move.b	#1,28(a3) 
	move.b	80(a3),d0 
	cmp.b	81(a3),d0 
	beq.b	l0097 
	bcs	l0081 
	neg.b	28(a3)
	bra	l0081 
l0096	move.b	81(a3),80(a3) 
l0097	move.b	#0,28(a3) 
	clr.w	0(a1) 
	bra	l0081 
l0098	lea	l011e(pc),a2
	bsr.b	l009a 
	bsr.b	l0099 
	bsr	l0099 
l0099	addq.l	#4,a2 
l009a	movea.l	352(a2),a4
	tst.b	0(a2) 
	beq.b	l009b 
	bpl	l00a2 
l009b	tst.w	256(a2) 
	bmi.b	l009c 
	subq.w	#1,256(a2)
	bra.b	l009d 
l009c	clr.b	259(a2) 
l009d	tst.w	62(a3)
	beq.b	l009e 
	tst.b	0(a2) 
	beq.b	l009e 
	bpl.b	l009f 
l009e	bsr	l00da 
	bsr	l00de 
	bsr	l00e2 
	bsr	l00e8 
l009f	tst.b	28(a3)
	beq.b	l00a0 
	subq.b	#1,82(a3) 
	bne.b	l00a0 
	move.b	83(a3),82(a3) 
	move.b	28(a3),d0 
	add.b	d0,80(a3) 
	move.b	81(a3),d0 
	cmp.b	80(a3),d0 
	bne.b	l00a0 
	clr.b	28(a3)
	lea	l0121(pc),a0
	clr.w	0(a0) 
l00a0	moveq	#0,d1 
	move.b	80(a3),d1 
	moveq	#0,d0 
	move.b	96(a2),d0 
	cmp.w	#$40,d1 
	beq.b	l00a1 
	add.w	d0,d0 
	add.w	d0,d0 
	mulu	d1,d0 
	lsr.w	#8,d0 
	andi.w	#$7f,d0 
l00a1	move.w	d0,8(a4)
l00a2	tst.b	0(a2) 
	beq.b	l00a4 
	bmi.b	l00a3 
	clr.w	64(a2)
	move.w	68(a3),66(a2) 
	move.b	#$ff,0(a2)
	move.w	#$ffff,98(a2) 
l00a3	tst.w	66(a2)
	beq.b	l00a5 
	subq.w	#1,66(a2) 
l00a4	rts
 
l00a5	movea.l	48(a2),a0 
	move.w	64(a2),d0 
	add.w	d0,d0 
	add.w	d0,d0 
	move.l	0(a0,d0.w),40(a3) 
	move.b	40(a3),d0 
	clr.b	40(a3)
	andi.w	#$ff,d0 
	add.w	d0,d0 
	add.w	d0,d0 
	cmp.w	#$84,d0 
	bcc	l00a7 
	jmp	l00a6(pc,d0.w)
l00a6	bra	l00aa 
	bra	l00ad 
	bra	l00ae 
	bra	l00b2 
	bra	l00b3 
	bra	l00ba 
	bra	l00bf 
	bra	l00c0 
	bra	l00c6 
	bra	l00c7 
	bra	l00d0 
	bra	l00cc 
	bra	l00ce 
	bra	l00c1 
	bra	l00c3 
	bra	l00cf 
	bra	l00be 
	bra	l00b0 
	bra	l00b1 
	bra	l00ab 
	bra	l00d1 
	bra	l00d5 
	bra	l00d6 
	bra	l00cb 
	bra	l00d7 
	bra	l00d8 
	bra	l00b5 
	bra	l00b8 
	bra	l00b6 
	bra	l00b7 
	bra	l00b9 
	bra	l00c5 
	bra	l00d9 
l00a7	addq.w	#1,64(a2) 
	tst.b	323(a2) 
	st	323(a2) 
	bmi.b	l00a8 
	beq.b	l00a8 
	bra	l00a5 
l00a8	rts
 
l00a9	addq.w	#1,64(a2) 
	bra	l00a5 
l00aa	clr.b	112(a2) 
	clr.b	146(a2) 
	clr.w	192(a2) 
	clr.b	291(a2) 
l00ab	tst.b	43(a3)
	beq.b	l00ac 
	move.b	43(a3),96(a2) 
	move.w	42(a3),8(a4)
l00ac	sf	369(a2) 
	sf	368(a2) 
	move.b	41(a3),323(a2)
	beq.b	l00a9 
	move.w	#1,6(a4)
	movem.l	a0-a4/d0-d6,-(a7) 
	bsr	l0045 
	movem.l	(a7)+,a0-a4/d0-d6 
	bra.b	l00a9 
l00ad	st	368(a2) 
	bra	l00a9 
l00ae	move.l	40(a3),d0 
	add.l	4(a3),d0
l00af	move.l	d0,176(a2)
	move.l	d0,(a4) 
	bra	l00a9 
l00b0	move.w	42(a3),d1 
	ext.l	d1
	move.l	176(a2),d0
	add.l	d1,d0 
	bra.b	l00af 
l00b1	move.w	42(a3),d0 
	move.w	208(a2),d1
	add.w	d0,d1 
	move.w	d1,208(a2)
	move.w	d1,4(a4)
	bra	l00a9 
l00b2	move.w	42(a3),208(a2)
	move.w	42(a3),4(a4)
	bra	l00a9 
l00b3	btst	#0,41(a3) 
	beq.b	l00b4 
	tst.b	1(a2) 
	bne	l00e7 
	move.b	#1,1(a2)
	bra	l00a9 
l00b4	move.w	42(a3),66(a2) 
	bra	l00a7 
l00b5	clr.b	0(a2) 
	st	369(a2) 
	bra	l00a7 
l00b6	move.b	41(a3),d0 
	cmp.b	17(a2),d0 
	bcc	l00a9 
	move.w	42(a3),64(a2) 
	bra	l00a5 
l00b7	move.b	41(a3),d0 
	cmp.b	96(a2),d0 
	bcc	l00a9 
	move.w	42(a3),64(a2) 
	bra	l00a5 
l00b8	move.b	41(a3),322(a2)
	move.w	42(a3),288(a2)
	move.w	#$101,290(a2) 
	bsr	l00e8 
	move.b	#1,1(a2)
	bra	l00a9 
l00b9	move.b	41(a3),211(a2)
	bra	l00a9 
l00ba	tst.b	98(a2)
	beq.b	l00bb 
	cmpi.b	#$ff,98(a2) 
	beq.b	l00bc 
	subq.b	#1,98(a2) 
	bra.b	l00bd 
l00bb	move.b	#$ff,98(a2) 
	bra	l00a9 
l00bc	move.b	41(a3),d0 
	subq.b	#1,d0 
	move.b	d0,98(a2) 
l00bd	move.w	42(a3),64(a2) 
	bra	l00a5 
l00be	tst.b	210(a2) 
	bne.b	l00ba 
	bra	l00a9 
l00bf	move.b	41(a3),d0 
	andi.l	#$7f,d0 
	movea.l	0(a3),a0
	add.w	d0,d0 
	add.w	d0,d0 
	adda.l	d0,a0 
	move.l	1536(a0),d0 
	add.l	0(a3),d0
	move.l	d0,48(a2) 
	move.w	42(a3),64(a2) 
	move.w	#$ffff,98(a2) 
	bra	l00a2 
l00c0	clr.b	0(a2) 
	rts
 
l00c1	cmpi.b	#$fe,42(a3) 
	bne.b	l00c2 
	move.b	17(a2),d2 
	move.b	43(a3),d3 
	clr.w	42(a3)
	bsr.b	l00c8 
	move.b	d3,43(a3) 
l00c2	move.w	32(a2),d0 
	add.w	d0,d0 
	add.w	32(a2),d0 
	add.w	42(a3),d0 
	move.b	d0,96(a2) 
	bra	l00a9 
l00c3	cmpi.b	#$fe,42(a3) 
	bne.b	l00c4 
	move.b	17(a2),d2 
	move.b	43(a3),d3 
	clr.w	42(a3)
	bsr.b	l00c8 
	move.b	d3,43(a3) 
l00c4	move.b	43(a3),96(a2) 
	bra	l00a9 
l00c5	move.b	16(a2),d2 
	bsr.b	l00c8 
	bra	l00a7 
l00c6	move.b	17(a2),d2 
	bsr.b	l00c8 
	bra	l00a7 
l00c7	moveq	#0,d2 
	bsr.b	l00c8 
	bra	l00a7 
l00c8	move.b	41(a3),d0 
	add.b	d2,d0 
	andi.b	#$3f,d0 
	ext.w	d0
	add.w	d0,d0 
	lea	l0123(pc),a0
	move.w	0(a0,d0.w),d0 
	andi.w	#$7fff,d0 
	move.w	34(a2),d1 
	add.w	42(a3),d1 
	beq.b	l00c9 
	addi.w	#$100,d1
	mulu	d1,d0 
	lsr.l	#8,d0 
l00c9	move.w	d0,160(a2)
	tst.w	192(a2) 
	bne	l00ca 
	move.w	d0,6(a4)
l00ca	rts
 
l00cb	move.w	42(a3),160(a2)
	tst.w	192(a2) 
	bne	l00a9 
	move.w	42(a3),6(a4)
	bra	l00a9 
l00cc	move.b	41(a3),130(a2)
	move.b	#1,131(a2)
	tst.w	192(a2) 
	bne.b	l00cd 
	move.w	160(a2),194(a2) 
l00cd	move.w	42(a3),192(a2)
	bra	l00a9 
l00ce	move.b	41(a3),d0 
	move.b	d0,146(a2)
	lsr.b	#1,d0 
	move.b	d0,147(a2)
	move.b	43(a3),128(a2)
	move.b	#1,129(a2)
	tst.w	192(a2) 
	bne	l00a9 
	move.w	160(a2),6(a4) 
	clr.w	144(a2) 
	bra	l00a9 
l00cf	move.b	42(a3),112(a2)
	move.b	41(a3),115(a2)
	move.b	42(a3),113(a2)
	move.b	43(a3),114(a2)
	bra	l00a9 
l00d0	clr.b	112(a2) 
	clr.b	146(a2) 
	clr.w	192(a2) 
	clr.b	291(a2) 
	bra	l00a9 
l00d1	tst.b	210(a2) 
	beq	l00a9 
	tst.b	98(a2)
	beq.b	l00d2 
	cmpi.b	#$ff,98(a2) 
	beq.b	l00d3 
	subq.b	#1,98(a2) 
	bra.b	l00d4 
l00d2	move.b	#$ff,98(a2) 
	bra	l00a9 
l00d3	move.b	43(a3),d0 
	subq.b	#1,d0 
	move.b	d0,98(a2) 
l00d4	rts
 
l00d5	move.l	48(a2),224(a2)
	move.w	64(a2),240(a2)
	move.b	41(a3),d0 
	andi.l	#$7f,d0 
	movea.l	0(a3),a0
	add.w	d0,d0 
	add.w	d0,d0 
	adda.l	d0,a0 
	move.l	1536(a0),d0 
	add.l	0(a3),d0
	move.l	d0,48(a2) 
	move.w	42(a3),64(a2) 
	bra	l00a2 
l00d6	move.l	224(a2),48(a2)
	move.w	240(a2),64(a2)
	bra	l00a9 
l00d7	move.l	40(a3),d0 
	add.l	d0,176(a2)
	move.l	176(a2),(a4)
	lsr.w	#1,d0 
	sub.w	d0,208(a2)
	move.w	208(a2),4(a4) 
	bra	l00a9 
l00d8	move.l	#PHF+$87bc,176(a2) 
	move.w	#$80,208(a2)
	move.l	#PHF+$87bc,(a4)
	move.w	#$80,4(a4)
	bra	l00a9 
l00d9	move.b	41(a3),d0 
	andi.w	#3,d0 
	add.w	d0,d0 
	lea	l0121(pc),a0
	move.w	42(a3),30(a0,d0.w)
	bra	l00a9 
l00da	tst.b	146(a2) 
	beq.b	l00dd 
	move.b	128(a2),d0
	ext.w	d0
	add.w	d0,144(a2)
	move.w	160(a2),d0
	move.w	144(a2),d1
	beq.b	l00db 
	andi.l	#$ffff,d0 
	addi.w	#$800,d1
	mulu	d1,d0 
	lsl.l	#5,d0 
	swap	d0
l00db	tst.w	192(a2) 
	bne.b	l00dc 
	move.w	d0,6(a4)
l00dc	subq.b	#1,147(a2)
	bne.b	l00dd 
	move.b	146(a2),147(a2) 
	eori.b	#$ff,128(a2)
	addq.b	#1,128(a2)
l00dd	rts
 
l00de	tst.w	192(a2) 
	beq.b	l00dd 
	subq.b	#1,131(a2)
	bne.b	l00dd 
	move.b	130(a2),131(a2) 
	move.w	160(a2),d1
	moveq	#0,d0 
	move.w	194(a2),d0
	cmp.w	d1,d0 
	beq.b	l00dd 
	bcs.b	l00e1 
	move.w	#$100,d2
	sub.w	192(a2),d2
	mulu	d2,d0 
	lsr.l	#8,d0 
	cmp.w	d1,d0 
	beq.b	l00df 
	bcc.b	l00e0 
l00df	clr.w	192(a2) 
	move.w	160(a2),d0
l00e0	andi.w	#$7ff,d0
	move.w	d0,194(a2)
	move.w	d0,6(a4)
	rts
 
l00e1	move.w	192(a2),d2
	addi.w	#$100,d2
	mulu	d2,d0 
	lsr.l	#8,d0 
	cmp.w	d1,d0 
	beq.b	l00df 
	bcc.b	l00df 
	bra.b	l00e0 
l00e2	tst.b	112(a2) 
	beq.b	l00e3 
	tst.b	113(a2) 
	beq.b	l00e4 
	subq.b	#1,113(a2)
l00e3	rts
 
l00e4	move.b	112(a2),113(a2) 
	move.b	114(a2),d0
	cmp.b	96(a2),d0 
	bgt.b	l00e6 
	move.b	115(a2),d1
	sub.b	d1,96(a2) 
	bmi	l00e5 
	cmp.b	96(a2),d0 
	bge.b	l00e5 
	rts
 
l00e5	move.b	114(a2),96(a2)
	clr.b	112(a2) 
	rts
 
l00e6	move.b	115(a2),d1
	add.b	d1,96(a2) 
	cmp.b	96(a2),d0 
	ble.b	l00e5 
l00e7	rts
 
l00e8	tst.b	291(a2) 
	beq.b	l00e7 
	bmi.b	l00e9 
	move.b	322(a2),d0
	andi.l	#$7f,d0 
	movea.l	0(a3),a0
	add.w	d0,d0 
	add.w	d0,d0 
	adda.l	d0,a0 
	move.l	1536(a0),d0 
	add.l	0(a3),d0
	move.l	d0,304(a2)
	clr.w	320(a2) 
	move.b	#$ff,291(a2)
	btst	#0,289(a2)
	beq	l00e9 
	bsr	l00f2 
l00e9	subq.b	#1,290(a2)
	bne	l00f4 
	move.b	288(a2),290(a2) 
	movea.l	304(a2),a0
l00ea	move.w	320(a2),d0
	move.b	0(a0,d0.w),d0 
	move.b	d0,40(a3) 
	bne.b	l00eb 
	tst.w	320(a2) 
	beq.b	l00e7 
	clr.w	320(a2) 
	bra.b	l00ea 
l00eb	add.b	17(a2),d0 
	andi.w	#$3f,d0 
	beq	l00f2 
	add.w	d0,d0 
	lea	l0123(pc),a0
	move.w	0(a0,d0.w),d0 
	move.w	34(a2),d1 
	beq.b	l00ec 
	addi.w	#$100,d1
	mulu	d1,d0 
	lsr.l	#8,d0 
l00ec	btst	#0,289(a2)
	bne.b	l00ee 
	move.w	d0,160(a2)
	tst.w	192(a2) 
	bne	l00e7 
	move.w	d0,6(a4)
	btst	#7,40(a3) 
	beq.b	l00ed 
	clr.b	1(a2) 
l00ed	addq.w	#1,320(a2)
	rts
 
l00ee	bsr	l00f6 
	btst	#2,289(a2)
	bne.b	l00ef 
	move.w	320(a2),d1
	andi.w	#3,d1 
	tst.w	d1
	bne.b	l00ef 
	moveq	#$10,d1 
	cmp.b	15(a3),d1 
	bcc.b	l00f1 
l00ef	btst	#7,40(a3) 
	beq.b	l00f0 
	clr.b	1(a2) 
l00f0	move.w	d0,160(a2)
	tst.w	192(a2) 
	bne	l00f1 
	move.w	d0,6(a4)
l00f1	addq.w	#1,320(a2)
	btst	#6,40(a3) 
	beq	l00e7 
	bsr	l00f6 
	move.w	#6,d1 
	cmp.b	14(a3),d1 
	bcc.b	l00f3 
l00f2	bsr	l00f6 
	moveq	#0,d1 
	move.b	15(a3),d1 
	and.b	211(a2),d1
	move.w	d1,320(a2)
l00f3	rts
 
l00f4	btst	#1,289(a2)
	beq	l00e7 
	moveq	#0,d0 
	move.b	288(a2),d0
	mulu	#3,d0 
	lsr.w	#3,d0 
	cmp.b	290(a2),d0
	bne	l00e7 
	move.w	160(a2),d0
	moveq	#0,d1 
	move.b	96(a2),d1 
	mulu	#5,d1 
	lsr.w	#3,d1 
	move.l	a2,-(a7)
	adda.l	336(a2),a2
	movea.l	352(a2),a4
	move.b	d1,96(a2) 
	cmp.w	160(a2),d0
	beq.b	l00f5 
	move.w	d0,160(a2)
	move.w	d0,6(a4)
	btst	#7,40(a3) 
	beq.b	l00f5 
	clr.b	1(a2) 
l00f5	movea.l	(a7)+,a2
	movea.l	352(a2),a4
	rts
 
l00f6	move.b	$ffff8209.w,d6
	move.b	d6,d5 
	lsl.w	#8,d6 
	move.b	$ffff8207.w,d6
	eor.b	d5,d6 
	eor.w	d6,14(a3) 
	move.w	14(a3),d6 
	addi.l	#$57294335,d6 
	move.w	d6,14(a3) 
	rts
 
l00f7	movem.l	a2-a4/d0,-(a7)
	lea	l011d(pc),a3
	move.l	40(a3),-(a7)
	lea	l011e(pc),a2
	move.l	d0,40(a3) 
	move.b	42(a3),d0 
	andi.w	#3,d0 
	add.w	d0,d0 
	add.w	d0,d0 
	adda.w	d0,a2 
	cmpi.b	#$fc,40(a3) 
	bne.b	l00f8 
	move.b	41(a3),259(a2)
	move.b	43(a3),d0 
	move.w	d0,256(a2)
	bra	l00fc 
l00f8	tst.b	259(a2) 
	bne	l00fc 
	cmpi.b	#$f7,40(a3) 
	bne.b	l00f9 
	move.b	41(a3),115(a2)
	move.b	42(a3),d0 
	lsr.b	#4,d0 
	addq.b	#1,d0 
	move.b	d0,113(a2)
	move.b	d0,112(a2)
	move.b	43(a3),114(a2)
	bra	l00fc 
l00f9	cmpi.b	#$f6,40(a3) 
	bne.b	l00fa 
	move.b	41(a3),d0 
	andi.b	#$fe,d0 
	move.b	d0,146(a2)
	lsr.b	#1,d0 
	move.b	d0,147(a2)
	move.b	43(a3),128(a2)
	move.b	#1,129(a2)
	clr.w	144(a2) 
	bra.b	l00fc 
l00fa	cmpi.b	#$f5,40(a3) 
	bne.b	l00fb 
	clr.b	210(a2) 
	bra.b	l00fc 
l00fb	cmpi.b	#$bf,40(a3) 
	bcc.b	l00fd 
	andi.w	#$3fff,40(a3) 
	move.b	43(a3),d0 
	ext.w	d0
	move.w	d0,34(a2) 
	move.b	42(a3),d0 
	lsr.b	#4,d0 
	andi.w	#$f,d0
	move.b	d0,33(a2) 
	move.b	41(a3),d0 
	move.b	d0,19(a2) 
	move.b	17(a2),16(a2) 
	move.b	40(a3),17(a2) 
	movea.l	0(a3),a4
	add.w	d0,d0 
	add.w	d0,d0 
	adda.w	d0,a4 
	movea.l	1536(a4),a4 
	adda.l	0(a3),a4
	move.l	a4,48(a2) 
	move.b	#1,0(a2)
	move.b	#1,210(a2)
l00fc	move.l	(a7)+,40(a3)
	movem.l	(a7)+,a2-a4/d0
	rts
 
l00fd	move.b	41(a3),130(a2)
	move.b	#1,131(a2)
	tst.w	192(a2) 
	bne.b	l00fe 
	move.w	160(a2),194(a2) 
l00fe	clr.b	192(a2) 
	move.b	43(a3),193(a2)
	move.b	40(a3),d0 
	andi.w	#$3f,d0 
	move.b	d0,17(a2) 
	add.w	d0,d0 
	lea	l0123(pc),a4
	move.w	0(a4,d0.w),160(a2)
	bra.b	l00fc 
l00ff	move.l	a2,-(a7)
	lea	l011e(pc),a2
	andi.w	#3,d0 
	add.w	d0,d0 
	add.w	d0,d0 
	adda.w	d0,a2 
	sf	368(a2) 
	sf	369(a2) 
	clr.b	0(a2) 
	clr.b	291(a2) 
	movea.l	(a7)+,a2
	rts
 
l0100	move.l	a3,-(a7)
	lea	l011d(pc),a3
	clr.b	46(a3)
	clr.w	PHF+$63d2
	clr.w	PHF+$63e4
	clr.w	PHF+$63f6
	clr.w	PHF+$6408
	clr.w	PHF+$a46c
	clr.w	PHF+$a470
	clr.w	PHF+$a474
	clr.w	PHF+$a478
	lea	l011e(pc),a3
	clr.b	0(a3) 
	clr.b	4(a3) 
	clr.b	8(a3) 
	clr.b	12(a3)
	clr.b	291(a3) 
	clr.b	295(a3) 
	clr.b	299(a3) 
	clr.b	303(a3) 
	movea.l	(a7)+,a3
	rts
 
l0101	btst	#0,60(a3) 
	bne.b	l0102 
	bsr.b	l0100 
l0102	clr.b	46(a3)
	move.w	#1,68(a3) 
	movea.l	4(a3),a4
	clr.l	(a4)
	clr.w	64(a3)
	movea.l	0(a3),a4
	move.b	61(a3),d0 
	andi.l	#$1f,d0 
	add.l	d0,d0 
	adda.l	d0,a4 
	lea	l011f(pc),a2
	move.b	12(a3),d1 
	bmi	l0103 
	andi.w	#$1f,d1 
	add.w	d1,d1 
	lea	l0120(pc),a0
	adda.w	d1,a0 
	move.w	4(a2),(a0)
	move.b	62(a3),64(a0) 
	clr.b	62(a3)
	move.b	7(a2),65(a0)
	move.w	52(a3),128(a0)
	clr.w	52(a3)
l0103	move.w	256(a4),4(a2) 
	move.w	256(a4),0(a2) 
	move.w	320(a4),2(a2) 
	move.w	384(a4),d2
	btst	#1,60(a3) 
	beq.b	l0104 
	lea	l0120(pc),a0
	adda.w	d0,a0 
	move.w	(a0),4(a2)
	move.b	64(a0),62(a3) 
	moveq	#0,d2 
	move.b	65(a0),d2 
	tst.w	128(a0) 
	beq	l0104 
	move.w	128(a0),52(a3)
	move.b	#1,92(a3) 
	move.b	#1,74(a3) 
l0104	move.b	92(a3),74(a3) 
	cmp.w	#$f,d2
	bls.b	l0106 
	cmp.w	#$1f,d2 
	bls.b	l0105 
	move.w	d2,d0 
	move.w	6(a2),d2
	move.l	#$1b51f8,d1 
	divu	d0,d1 
	move.w	d1,52(a3) 
	move.b	#1,92(a3) 
	move.b	#1,74(a3) 
	bra	l0106 
l0105	move.b	#1,62(a3) 
	subi.w	#$10,d2 
	move.w	#2,68(a3) 
l0106	move.w	#$1c,d1 
	lea	l0122(pc),a4
l0107	move.l	a4,40(a2,d1.w)
	move.w	#$ff00,72(a2,d1.w)
	clr.l	104(a2,d1.w)
	subq.w	#4,d1 
	bpl.b	l0107 
	move.w	d2,6(a2)
	tst.b	61(a3)
	bmi.b	l0108 
	movea.l	0(a3),a4
	bsr	l0080 
l0108	clr.b	9(a3) 
	clr.w	44(a3)
	move.w	#$ffff,98(a3) 
	move.b	61(a3),12(a3) 
	move.w	#$ffff,60(a3) 
	lea	l011e(pc),a2
	clr.b	259(a2) 
	clr.b	263(a2) 
	clr.b	267(a2) 
	clr.b	271(a2) 
	clr.w	256(a2) 
	clr.w	260(a2) 
	clr.w	264(a2) 
	clr.w	268(a2) 
	move.b	#1,46(a3) 
	rts
 
l0109	movem.l	a2-a3,-(a7) 
	lea	l011d(pc),a3
	lea	l0121(pc),a2
	move.w	#1,0(a2)
	move.b	d0,81(a3) 
	swap	d0
	move.b	d0,82(a3) 
	move.b	d0,83(a3) 
	beq.b	l010a 
	move.b	80(a3),d0 
	move.b	#1,28(a3) 
	cmp.b	81(a3),d0 
	beq.b	l010b 
	bcs.b	l010c 
	neg.b	28(a3)
	bra.b	l010c 
l010a	move.b	81(a3),80(a3) 
l010b	move.b	#0,28(a3) 
	clr.w	0(a2) 
l010c	movem.l	(a7)+,a2-a3 
	rts
 
l010d	lea	l0121(pc),a0
	rts
 
l010e	movem.l	a1-a4,-(a7) 
	lea	l011d(pc),a3
	lea	l011f(pc),a2
	move.w	#1,64(a3) 
	movea.l	0(a3),a4
	movea.l	a4,a1 
	adda.l	#$400,a1
	move.w	d0,100(a2)
	andi.w	#$7f00,d0 
	lsr.w	#6,d0 
	move.l	0(a1,d0.w),d0 
	add.l	a4,d0 
	move.l	d0,68(a2) 
	clr.l	132(a2) 
	move.w	#$ffff,102(a2)
	movem.l	(a7)+,a1-a4 
	rts
 
l010f	movem.l	a2-a3,-(a7) 
	lea	l011d(pc),a3
	lea	l011f(pc),a2
	move.w	#1,64(a3) 
	move.w	d0,100(a2)
	move.l	a1,68(a2) 
	clr.l	132(a2) 
	move.w	#$ffff,102(a2)
	movem.l	(a7)+,a2-a3 
	rts
 
l0110	movem.l	a2-a4/d1-d3,-(a7) 
	lea	l011d(pc),a3
	lea	l011e(pc),a4
	move.w	d0,d2 
	movea.l	0(a3),a2
	movea.l	1532(a2),a2 
	adda.l	0(a3),a2
	lsl.w	#3,d2 
	cmpi.b	#$fb,0(a2,d2.w) 
	bne.b	l0111 
	move.w	2(a2,d2.w),d0 
	bsr	l010e 
	bra.b	l0115 
l0111	move.b	2(a2,d2.w),d3 
	cmpi.b	#$ff,12(a3) 
	bne	l0112 
	move.b	4(a2,d2.w),d3 
l0112	andi.w	#3,d3 
	add.w	d3,d3 
	add.w	d3,d3 
	adda.w	d3,a4 
	lsl.w	#6,d3 
	move.b	5(a2,d2.w),d1 
	bclr	#7,d1 
	cmp.b	259(a4),d1
	bcc.b	l0113 
	tst.w	256(a4) 
	bpl.b	l0115 
l0113	cmp.b	258(a4),d2
	bne.b	l0114 
	tst.w	256(a4) 
	bmi.b	l0114 
	btst	#7,5(a2,d2.w) 
	bne.b	l0115 
l0114	clr.b	259(a4) 
	move.l	0(a2,d2.w),d0 
	andi.l	#$fffff0ff,d0 
	or.w	d3,d0 
	bsr	l00f7 
	move.b	d1,259(a4)
	move.w	6(a2,d2.w),256(a4)
	move.b	d2,258(a4)
l0115	movem.l	(a7)+,a2-a4/d1-d3 
	rts
 
l0116	bset	#8,d0 
l0117	movem.l	a2-a3,-(a7) 
	bsr	l011b 
	lea	l011d(pc),a3
	move.w	d0,60(a3) 
	clr.b	74(a3)
	clr.b	93(a3)
	movem.l	(a7)+,a2-a3 
	rts
 
l0118	movem.l	a2-a3,-(a7) 
	bsr	l011b 
	lea	l011d(pc),a3
	andi.w	#$1f,d0 
	bset	#9,d0 
	move.w	d0,60(a3) 
	clr.b	93(a3)
	movem.l	(a7)+,a2-a3 
	rts
 
l0119	movem.l	a2-a4,-(a7) 
	lea	l011d(pc),a3
	move.l	#$40400000,80(a3) 
	move.l	d0,0(a3)
	move.l	d1,4(a3)
	move.b	#1,8(a3)
	lea	l011e(pc),a2
	move.w	#5,6(a2)
	lea	l0120(pc),a3
	moveq	#$1f,d0 
l011a	move.w	#5,64(a3) 
	clr.w	128(a3) 
	clr.w	(a3)+ 
	dbf	d0,l011a
	movem.l	(a7)+,a2-a4 
	rts
 
l011b	pea	(a3)
	lea	l011d(pc),a3
	sf	92(a3)
	movea.l	(a7)+,a3
	rts
 
l011c	move.l	a3,-(a7)
	lea	l011d(pc),a3
	bsr	l0100 
	movea.l	(a7)+,a3
	rts
 
l011d	dcb.w	26,0
	dc.b	$7f,$ff,$00,$00,$00,$00,$00,$00 
	dc.b	$ff,$ff,$00,$00,$00,$00,$00,$00 
	dc.b	$00,$01,$00,$00,$00,$00,$00,$00 
	dcb.w	2,0 
	dc.b	'@@',$00,$00,$00,$00,$00,$00
	dcb.w	3,0 
	dc.b	$ff,$ff 
l011e	dcb.w	40,0
	dc.b	'AMI-EMU BY J.H.!'
	dcb.w	88,0
	dc.b	'HI, MUSIC-FREAKS'
	dcb.w	25,0
	dc.b	$00,$04,$00,$00,$00,$04,$00,$00 
	dc.b	$00,$04,$ff,$ff,$ff,$f4
	dc.l	PHF+$63ca
	dc.l	PHF+$63dc
	dc.l	PHF+$63ee
	dc.l	PHF+$6400
	dc.b	$00,$00 

	dcb.w	7,0 
l011f	dcb.w	3,0 
	dc.b	$00,$06,$00,$00,$00,$00,$00,$00 
	dcb.w	93,0
l0120	dcb.w	96,0
l0121	dcb.w	19,0
l0122	dc.b	$f4,$00,$00,$00,$f0,$00,$00,$00 
l0123	dc.b	$06,$ae,$06,'N',$05,$f4,$05,$9e 
	dc.b	$05,'M',$05,$01,$04,$b9,$04,'u' 
	dc.b	$04,'5',$03,$f9,$03,$c0,$03,$8c 
	dc.b	$03,'X',$03,'*',$02,$fc,$02,$d0 
	dc.b	$02,$a8,$02,$82,$02,'^',$02,';' 
	dc.b	$02,$1b,$01,$fd,$01,$e0,$01,$c6 
	dc.b	$01,$ac,$01,$94,$01,'}',$01,'h' 
	dc.b	$01,'T',$01,'@',$01,'/',$01,$1e 
	dc.b	$01,$0e,$00,$fe,$00,$f0,$00,$e3 
	dc.b	$00,$d6,$00,$ca,$00,$bf,$00,$b4 
	dc.b	$00,$aa,$00,$a0,$00,$97,$00,$8f 
	dc.b	$00,$87,$00,$7f,$00,'x',$00,'q' 
	dc.b	$00,$d6,$00,$ca,$00,$bf,$00,$b4 
	dc.b	$00,$aa,$00,$a0,$00,$97,$00,$8f 
	dc.b	$00,$87,$00,$7f,$00,'x',$00,'q' 
	dc.b	$00,$d6,$00,$ca,$00,$bf,$00,$b4 

song	incbin	"zout.son"		< T.F.M.X.  Music File

	even

v_sync	move.w	#-1,vsync_flag
.sync	tst.w	vsync_flag
	bne.s	.sync
	rts



***********************
* SUBROUTINES SECTION *
***********************


set_up		lea	bss_start,a0
		move.l	#bss_end-bss_start,d0
.clr_bss	clr.b	(a0)+
		sub.l	#1,d0
		bne.s	.clr_bss

		clr.l	-(sp)
		move.w	#$20,-(sp)
		trap	#1
		addq.l	#6,sp
		move.l	d0,stack_save

		move.b	#$12,$fffffc02.w	;DI mouse

		move.w	#3,-(sp)
		trap	#14
		addq.l	#2,sp
		move.l	d0,screen_base

		movem.l	$ffff8240.w,d0-d7
		movem.l	d0-d7,old_palette

		movem.l	pic+2,d0-d7
		movem.l	d0-d7,$ffff8240.w

		move.b	$ffff8260.w,original_rez

		move.w	#$25,-(sp)
		trap	#14
		addq.l	#2,sp

		clr.b	$ffff8260.w

		jsr	sort_text

		move.w	#$2700,sr
		lea	storage,a0
		move.l	$60.w,(a0)+
		move.l	$70.w,(a0)+
		move.l	$90.w,(a0)+
		move.l	$114.w,(a0)+
		move.l	$118.w,(a0)+
		move.l	$120.w,(a0)+
		move.l	$134.w,(a0)+

		move.b	$fffffa01.w,(a0)+
		move.b	$fffffa03.w,(a0)+
		move.b	$fffffa05.w,(a0)+
		move.b	$fffffa07.w,(a0)+
		move.b	$fffffa09.w,(a0)+
		move.b	$fffffa0b.w,(a0)+
		move.b	$fffffa0d.w,(a0)+
		move.b	$fffffa0f.w,(a0)+
		move.b	$fffffa11.w,(a0)+
		move.b	$fffffa13.w,(a0)+
		move.b	$fffffa15.w,(a0)+
		move.b	$fffffa17.w,(a0)+
		move.b	$fffffa19.w,(a0)+
		move.b	$fffffa1b.w,(a0)+
		move.b	$fffffa1d.w,(a0)+
		move.b	$fffffa1f.w,(a0)+
		move.b	$fffffa21.w,(a0)+
		move.b	$fffffa23.w,(a0)+
		move.b	$fffffa25.w,(a0)+
		move.l	#new90,$90.w
		move.l	#new_vbl,$70.w
		move.l	#new_kbd,$118.w
		andi.b	#$df,$fffffa09.w
		andi.b	#$fe,$fffffa07.w
		move.l	#new_timerb,$120.w
		move.b	#18,$fffffa21.w
		ori.b	#1,$fffffa07.w
		ori.b	#1,$fffffa13.w
		bclr	#3,$fffffa17.w		;auto isr ena

		move.b	#8,$fffffa1b.w

		move.l	#screens,d0
		clr.b	d0
		move.l	d0,scr_now
		move.l	d0,d1
		add.l	#32000,d1
		eor.l	d0,d1
		move.l	d1,scr_xor

		lea	pic+34,a0
		move.l	scr_now,a1
		move.l	a1,a2
		add.l	#32000,a2
		move.w	#32000/4-1,d0
.show		move.l	(a0),(a1)+
		move.l	(a0)+,(a2)+
		dbf	d0,.show
		bsr	set_screen
		bsr	set_screen

*************************************************************************
;Parameter List:
; Title				D0	D1	D2
;-------------------------------------------------------
; Z-Out				0-2	8	$fff6
		move.l	#0,d0
		move.l	#8,d1
		move.l	#$fff6,d2
		jsr	PHF		;Initialise

		move.l	#0,d0		;0,1 or 2 for tunes *************
		jsr	PHF+8		;Tune Selection

		move.w	#$2300,sr
*************************************************************************
		rts

set_screen	move.l	scr_now,d4
		move.l	d4,last_base
		move.l	scr_xor,d5
		eor.l	d5,d4
		move.l	d4,scr_now
		lsr.l	#8,d4
		lea	$ffff8201.w,a4
		movep.w	d4,(a4)
		rts

shut_down	move.w	#$2700,sr
		lea	storage,a0
		move.l	(a0)+,$60.w
		move.l	(a0)+,$70.w
		move.l	(a0)+,$90.w
		move.l	(a0)+,$114.w
		move.l	(a0)+,$118.w
		move.l	(a0)+,$120.w
		move.l	(a0)+,$134.w
		move.b	(a0)+,$fffffa01.w
		move.b	(a0)+,$fffffa03.w
		move.b	(a0)+,$fffffa05.w
		move.b	(a0)+,$fffffa07.w
		move.b	(a0)+,$fffffa09.w
		move.b	(a0)+,$fffffa0b.w
		move.b	(a0)+,$fffffa0d.w
		move.b	(a0)+,$fffffa0f.w
		move.b	(a0)+,$fffffa11.w
		move.b	(a0)+,$fffffa13.w
		move.b	(a0)+,$fffffa15.w
		move.b	(a0)+,$fffffa17.w
		move.b	(a0)+,$fffffa19.w
		move.b	(a0)+,$fffffa1b.w
		move.b	(a0)+,$fffffa1d.w
		move.b	(a0)+,$fffffa1f.w
		move.b	(a0)+,$fffffa21.w
		move.b	(a0)+,$fffffa23.w
		move.b	(a0)+,$fffffa25.w
		move.w	#$2300,sr
		move.b	#$f0,$fffffa23.w
		move.l	#$8080000,$ffff8820.w
		move.l	#$9090000,$ffff8820.w
		move.l	#$a0a0000,$ffff8820.w
		move.l	#$707ffff,$ffff8820.w

		movem.l	old_palette,d0-d7
		movem.l	d0-d7,$ffff8240.w

		move.w	#$25,-(sp)
		trap	#14
		addq.l	#2,sp

		move.l	screen_base,d4
		lsr.l	#8,d4
		lea	$ffff8201.w,a4
		movep.w	d4,(a4)

		move.b	original_rez,$ffff8260.w

		move.b	#$8,$fffffc02.w

		move.l	stack_save,-(sp)
		move.w	#$20,-(sp)
		trap	#1
		addq.l	#6,sp
		rts




*******************
   SECTION DATA
*******************
pic			incbin	pic.pi1


text_pos		dc.l	middle_text
middle_text		incbin	ascii.s
			dc.b	$ff
			even
font			incbin	oz_font.dat
			even

colours		dc.w	$300,$400,$500,$600,$700,$720,$730,$740,$750,$760
		dc.w	$770,$570

demo_keys
	dc.b	0, $02		;key 1
	dc.b	1, $03		;key 2
	dc.b	2, $04		;key 3
	dc.b	3, $05		;key 4
	dc.b	4, $06		;key 5
	dc.b	5, $07		;key 6
;	dc.b	6, $08		;key 7
;	dc.b	7, $09		;key 8
;	dc.b	8, $0a		;key 9

	dc.b	0, $6d		;keypad 1
	dc.b	1, $6e		;keypad 2
	dc.b	2, $6f		;keypad 3
	dc.b	3, $6a		;keypad 4
	dc.b	4, $6b		;keypad 5
	dc.b	5, $6c		;keypad 6
;	dc.b	6, $67		;keypad 7
;	dc.b	7, $68		;keypad 8
;	dc.b	8, $69		;keypad 9
	dc.b	-1, -1

filename_table	dc.l	exec1,exec2,exec3,exec4,exec5,exec6,exec7,exec8
exec1	dc.b	"cuddly.ro",0
	even
exec2	dc.b	"fuzion.189",0
	even
exec3	dc.b	"F_A_L_L.prg",0
	even
exec4	dc.b	"UNT.13",0
	even
exec5	dc.b	"NIRVANA.U",0
	even
exec6	dc.b	"copier.pov",0
	even
exec7	dc.b	"filename.ext",0
	even
exec8	dc.b	"filename.ext",0
	even


*******************
   SECTION BSS
*******************
bss_start

colour_pos		ds.l	1
clear_line_offset	ds.l	1
lines_to_do		ds.w	1
do_clear_delay		ds.w	1
disc_clear_enable	ds.w	1
disc_enable		ds.w	1
xpos			ds.b	1
ypos			ds.b	1
disc_start_table	ds.l	50	;1 long word for each page

stack_save	ds.l	1
screen_base	ds.l	1
original_rez	ds.w	1
old_palette	ds.w	16
hertz_toggle	ds.w	1
hertz_delay	ds.w	1
scr_now		ds.l	1
scr_xor		ds.l	1
last_base	ds.l	1

key		ds.w	1
vsync_flag	ds.w	1

storage		ds.b	48

		ds.b	256
screens		ds.b	32000
		ds.b	32000
bss_end

